IF NOT OBJECT_ID('UFD_EST_ALCADA_PRECO') IS NULL
	BEGIN 
		DROP FUNCTION UFD_EST_ALCADA_PRECO
	END

GO
 
CREATE FUNCTION DBO.UFD_EST_ALCADA_PRECO(@CD_USU INT, @CD_FILIAL INT)
RETURNS @RS_RESULT TABLE (CD_EMP		INT,
						  CD_PROD		INT,
						  CD_GRUPO		INT,
						  VLR_BASE		MONEY)

AS 
	BEGIN

		DECLARE @TBL_ALCADA TABLE ( CD_EMP					INT,
									CD_ARV_MERC_CATEG		INT, 
									CD_ARV_MERC_PAPEL		INT,
									PERC_ALCADA				MONEY)

		
		DECLARE @CD_GRUPO INT
		
		SET @CD_GRUPO = (SELECT 
							EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_GRUPO 
						 FROM EST_PRECIFICACAO_GRP_PRECO 
							INNER JOIN EST_PRECIFICACAO_GRP_PRECO_FILIAL ON 
								EST_PRECIFICACAO_GRP_PRECO.CD_EMP = EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_EMP
								AND EST_PRECIFICACAO_GRP_PRECO.CD_GRUPO = EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_GRUPO
						 WHERE 
							EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_FILIAL = @CD_FILIAL)
		
		INSERT INTO @TBL_ALCADA
			SELECT 
				ALCADA_IT.CD_EMP, 
				ALCADA_IT.CD_ARV_MERC_CATEG, 
				ALCADA_IT.CD_ARV_MERC_PAPEL, 
				MAX(ALCADA_IT.PERC_ALCADA) AS PERC_ALCADA
			FROM EST_ALCADA_PRECO_PAPEL_EST_ARV_MERC_CATEGORIA ALCADA_IT
				INNER JOIN EST_ALCADA_PRECO_GLB_USU ALCADA_USU ON 
					ALCADA_IT.CD_ALCADA = ALCADA_USU.CD_ALCADA
			WHERE 
				ALCADA_USU.CD_USU = @CD_USU
			GROUP BY 
				ALCADA_IT.CD_EMP,
				ALCADA_IT.CD_ARV_MERC_CATEG, 
				ALCADA_IT.CD_ARV_MERC_PAPEL

		INSERT INTO @RS_RESULT
			SELECT 
				P.CD_EMP, 
				P.CD_PROD, 
				P.CD_GRUPO,
				ROUND((H.VLR_LISTA / (1 - (((TBL_ALCADA.PERC_ALCADA / 100 * ISNULL(H.VLR_MMIN,0)) + H.ICMS_VENDA + ISNULL(H.PIS_COFINS,0) + ISNULL(H.ADIC_MARKUP,0) + ISNULL(H.PERC_MARGEM_PAPEL,0)) / 100))) - ISNULL(H.VLR_VERBA,0),2) AS VLR_BASE
			FROM EST_PROD_PRECIFICACAO_PRECO P
				INNER JOIN EST_PROD_PRECIFICACAO_HISTORICO H ON 
					P.CD_EMP		= H.CD_EMP
					AND P.CD_GRUPO	= H.CD_GRUPO
					AND P.CD_PROD	= H.CD_PROD
					AND P.DT_PRECO_BASE = H.DT_PRECO_BASE
				INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON 
					P.CD_EMP		= ARV.CD_EMP		
					AND P.CD_PROD	= ARV.CD_PROD
				INNER JOIN @TBL_ALCADA TBL_ALCADA ON 
					TBL_ALCADA.CD_EMP					= ARV.CD_EMP		
					AND TBL_ALCADA.CD_ARV_MERC_CATEG	= ARV.CD_ARV_MERC_CATEG
					AND TBL_ALCADA.CD_ARV_MERC_PAPEL	= ARV.CD_ARV_MERC_PAPEL
			WHERE 
				P.CD_EMP 	= 1
				AND P.CD_GRUPO 	= @CD_GRUPO

		RETURN

	END
 